# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cognitiveservices import CognitiveServicesManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCognitiveServicesManagementEncryptionScopesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CognitiveServicesManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_encryption_scopes_list(self, resource_group):
        response = self.client.encryption_scopes.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_encryption_scopes_get(self, resource_group):
        response = self.client.encryption_scopes.get(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_encryption_scopes_create_or_update(self, resource_group):
        response = self.client.encryption_scopes.create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            encryption_scope={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "keySource": "Microsoft.KeyVault",
                    "keyVaultProperties": {
                        "identityClientId": "str",
                        "keyName": "str",
                        "keyVaultUri": "str",
                        "keyVersion": "str",
                    },
                    "provisioningState": "str",
                    "state": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_encryption_scopes_begin_delete(self, resource_group):
        response = self.client.encryption_scopes.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            api_version="2025-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
