
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileEmagramAttributes.h
    \brief Definition of Emagram Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef EmagramAttributes_H
#define EmagramAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class EmagramAttributes 
{
public:
//  --  constructor
    EmagramAttributes();
    
//  --  destructor
    virtual ~EmagramAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const EmagramAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double x_min_;
	bool x_automatic_;
	bool y_automatic_;
	double x_max_;
	double y_min_;
	double y_max_;
	double annotation_width_;
	 

private:
	friend ostream& operator<<(ostream& s,const EmagramAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

